package test

import (
	"fmt"
	"github.com/gruntwork-io/terratest/modules/http-helper"
	"github.com/gruntwork-io/terratest/modules/random"
	"github.com/gruntwork-io/terratest/modules/terraform"
	"testing"
	"time"
)

func TestAlbExample(t *testing.T) {

	t.Parallel()

	opts := &terraform.Options{
		// Powinieneś uaktualnić tę względną ścieżkę dostępu,
    // aby prowadziła do katalogu examples!
		TerraformDir: "../examples/alb",

		Vars: map[string]interface{}{
			"alb_name": fmt.Sprintf("test-%s", random.UniqueId()),
		},

	}

	// Usunięcie całej infrastruktury po zakończeniu testu.
	defer terraform.Destroy(t, opts)

	// Wdrożenie przykładu.
	terraform.InitAndApply(t, opts)

	// Pobranie adresu URL mechanizmu równoważenia obciążenia.
	albDnsName := terraform.OutputRequired(t, opts, "alb_dns_name")
	url := fmt.Sprintf("http://%s", albDnsName)

	// Sprawdzenie, czy domyślna akcja ALB działa prawidłowo i zwraca kod stanu 404.
	expectedStatus := 404
	expectedBody := "404: nie znaleziono strony"

	maxRetries := 10
	timeBetweenRetries := 10 * time.Second

	http_helper.HttpGetWithRetry(
		t,
		url,
		nil,
		expectedStatus,
		expectedBody,
		maxRetries,
		timeBetweenRetries,
	)

}

